#version 140
#extension GL_EXT_gpu_shader4 : enable
//White DropsMod01.fsh by Xor
// License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
//https://www.shadertoy.com/view/fdXXWH
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iGlobalTime u_Elapsed


#define iTime u_Elapsed  //*0.3090234
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )


//#define iChannel0 sampler2D
//#define iChannel1 sampler2D
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract







//Anti-Aliasing (SSAA). Use 1.0 on slower computers
#define AA 2.

//Background gradient
vec3 background(vec3 d)
{
    float light = dot(d,sqrt(vec3(.3,.5,.2)));
    
    return vec3(max(light*.5+.5,.0));
}
//Smooth minimum (based off IQ's work)
float smin(float d1, float d2)
{
    const float e = -6.;
    return log(exp(d1*e)+exp(d2*e))/e;
}
//Ripple and drop distance function
float dist(vec3 p)
{
    float l = pow(dot(p.xz,p.xz),.8);
    float ripple = p.y+.8+.4*sin(l*3.-iTime+.5)/(1.+l);
    
    float h1 = -sin(iTime);
    float h2 = cos(iTime+.1);
    float drop = length(p+vec3(0,1.2,0)*h1)-.4;
    drop = smin(drop,length(p+vec3(.1,.8,0)*h2)-.2);
    return smin(ripple,drop);
}
//Typical SDF normal function
vec3 normal(vec3 p)
{
    vec2 e = vec2(1,-1)*.01;
    
    return normalize(dist(p-e.yxx)*e.yxx+dist(p-e.xyx)*e.xyx+
    dist(p-e.xxy)*e.xxy+dist(p-e.y)*e.y);
}
//Basic raymarcher
vec4 march(vec3 p, vec3 d)
{
    vec4 m = vec4(p,0);
    for(int i = 0; i<99; i++)
    {
        float s = dist(m.xyz);
        m += vec4(d,1)*s;
        
        if (s<.01 || m.w>20.) break;
    }
    return m;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 res = iResolution.xy;
    vec3 col = vec3(0);
    
    vec3 pos = vec3(.05*cos(iTime),.1*sin(iTime),-4);
    vec3 lig = sqrt(vec3(.3,.5,.2));
    
    //Sample
    for(float x = 0.;x<AA;x++)
    for(float y = 0.;y<AA;y++)
    {
        vec3 ray = normalize(vec3(gl_FragCoord.xy-res/2.+vec2(x,y)/AA,res.y));
        vec4 mar = march(pos,ray);
        vec3 nor = normal(mar.xyz);
        vec3 ref = refract(ray,nor,.75);
        float r = smoothstep(.8,1.,dot(reflect(ray,nor),lig));
        float l = 1.-dot(ray,nor);
        vec3 wat = background(ref)+.3*r*l*l;
        vec3 bac = background(ray)*.5+.5;

        float fade = pow(min(mar.w/20.,1.),.3);
        col += mix(wat,bac,fade);
    }
    col /= AA*AA;

    gl_FragColor = vec4(col*col,1);
}